	% 
	clear all
	close all
	clc
	fs = 16; lw = 2; fn = 'times'; 
	% Requirements for the digital lowpass filter	
	wcT = 0.55*pi; wsT = 0.6*pi;Amax = 0.1; Amin = 60;	
	wT = linspace(0, pi, 1000); S = zeros(1,1000);
	
	Coeff = [36 58 24 21 48 26 14 42 16 32 44 32 50 36];
	delta = zeros(1,14);
	Wd = 6; WX = 2^Wd;
	e = zeros(22,1); X = ones(22,1); G = zeros(22,1);
	sig=0;
	figure(1)
	alpa = (Coeff)/WX;
	%=====================================================
	c1 = 0.5 ; c2 =1; c3 = 1; c4 = 2; c5 = 1; c6 = 1;
	c7 = 2; c13 = 1; c12 = 0.5; c11 = 1; c10 = 2;c9 = 0.5; c8 = 0.5; c14 = 1;
	x0 = 0;
	%===========     
	for m = 1:22
		a1 = 0; a2 = 0; v1 = 0; v2 = 0; v3 = 0; v4 = 0; v5 = 0; v6 = 0; 
		v7 = 0; v8 = 0; v9 = 0; v10 = 0; v11 = 0; v12 = 0; v13 = 0;
		F1=0;F2=0;F3=0;F4=0;F5=0;F6=0;F7=0;F8=0;F9=0;F10=0;F11=0;F12=0;F131=0;F132=0;F22=0;	
		
		e(m,1) = 1; sig = 0;
		for n = 1:22
			
			% Adaptor I
			if m == 22
				a1 = e(22,1);
			end
			T11 = v1 - a1*c1 + e(15,1); X(15,1) = (1-c1^2);
			%			F1 = F1+T11^2;
			T12 = -alpa(1)*T11 + e(1,1); 
			x1 = T12 + v1; 
			x1s = x1*c3;
			% Adaptor II 
			T21 = v3 + v2;
			%			F2 = F2+T21^2;
			T22 = -alpa(2)*T21 + e(2,1); 
			x2 = T22 + v3; 
			x2s = x2*c2;
			% Adaptor III - Series
			x3 = -x1s - x2s;
			x3s = x3*c4;
			% Adaptor IV	
			T41 = v4 - x3s;
			%			F4 = F4+T41^2;
			T42 = -alpa(4)*T41 + e(4,1); 
			x4 = T42 + v4;
			x4s = x4*c6;
			% Adaptor V
			T51 = v6 + v5;
			%			F5 = F5+T51^2;
			T52 = -alpa(5)*T51 + e(5,1); 
			x5 = T52 + v6;
			x5s = x5*c5;
			% Adaptor VI - Series
			x6 = -x4s - x5s;
			x6s = x6*c14;
			% Adaptor VII
			T71 = a2*c7 - v13; 
			%			F7 = F7+T71^2;
			T72 = -alpa(7)*T71+ e(7,1); 
			x12 = T72 + a2*c7;
			x12s = x12*c9 + e(20,1); X(20,1) = 1-c9^2;
			% Adaptor VIII
			T81 = v12 + v11;
			%			F8 = F8 + T81^2;
			T82 = -alpa(8)*T81 + e(8,1); 
			x11 = T82 + v12;
			x11s = x11*c8 + e(21,1); X(21,1) = (1-c8^2);
			% Adaptor IX -series
			x10 = -x11s - x12s;
			x10s = x10*c10 ;
			% Adaptor X	
			T101 = x10s - v10;
			%			F10 = F10+T101^2;
			T102 = -alpa(10)*T101 + e(10,1); 
			x9 = T102 + x10s;
			x9s = x9*c12 + e(18,1); X(18,1) = (1-c12^2);
			% Adaptor XI
			T111 = v9 + v8; 
			%			F11 = F11+T111^2;
			T112 = -alpa(11)*T111 + e(11,1); 
			x8 = T112 + v9;
			x8s = x8*c11;
			% Adaptor XII -series
			x7 = -x8s - x9s;
			x7s = x7*c13;
			% Adaptor XIII
			T131 = x7s - v7; 
			T132 = x7s - x6s; 
			%			F131 = F131 + T131^2;
			%			F132 = F132 + T132^2;
			u7 = -alpa(13)*T131 - alpa(14)*T132 + x7s + e(13,1) + e(14,1);
			v7 = T131 + u7; 
			u6 = T132 + u7; 
			u6s = u6/c14;
			u7s = u7/c13;
			% Adaptor VI -series
			%			F6 = F6+(u6s  - x6)^2;
			u4 = x4s - alpa(6)*(u6s - x6) + e(6,1); 
			u5 = -u4 - u6s;
			u5s = u5/c5;
			u4s = u4/c6; 
			% Adaptor V
			v6 = T52 + u5s; 
			v5 = T51 + v6; 
			% Adaptor IV
			v4 = T42 + u4s; 
			u3 = T41 + v4;
			u3s = u3/c4 + e(16,1); X(16,1) = (1-c4^-2);
			% Adaptor III -series
			%			F3 = F3 + (u3s - x3)^2;
			u1 = (x1s - alpa(3)*(u3s - x3)) + e(3,1); 
			u2 = -u1 - u3s; 
			u2s = u2/c2;
			u1s = u1/c3;
			% Adaptor II
			v3 = T22 + u2s; 
			v2 = T21 + v3; 
			% Adaptor I	
			v1 = T12 + u1s; 
			b1 = T11 + v1;
			b1 = b1/c1;
			% Adaptor XII -series
			%			F12 = F12+(u7s - x7)^2;
			u8 = x8s - alpa(12)*(u7s - x7) + e(12,1); 
			u9 = -u8 - u7s; 
			u9s = u9/c12;
			u8s = u8/c11;
			% Adaptor XI
			v9 = T112 + u8s; 
			v8 = T111 + v9; 
			% Adaptor X
			u10 = T102 + u9s; 
			v10 = T101 + u10;
			u10s = u10/c10 + e(19,1); X(19,1) = (1-c10^-2);
			% Adaptor IX -series
			%				F9 = F9+(u10s - x10)^2;
			u11 = x11s - alpa(9)*(u10s - x10) + e(9,1);
			u12 = -u11 - u10s;
			u12s = u12/c9;
			u11s = u11/c8;
			% Adaptor VIII
			v12 = T82 + u11s; 
			v11 = T81 + v12; 
			% Adaptor VII
			b2 = T72 + u12s; 
			v13 = T71 + b2; 
			a1 = 0;			% reset the input
			h(n) = b2/c7 + e(17,1); X(17,1) = (1-c7^-2);
			%			F22 = F22+h(n)^2;
			if m == 22
				h0(n) = h(n);
			end
			e = zeros(22,1);
		end
		sig = sig + F22;	
		if h(1) == 0, h(1) = []; end
		if m == 22, h=h0;end
		[G, Z, P] = IMPULSE_2_P_Z(h, 9);	
		H = PZ_2_FREQ_Z(G, Z, P, wT);
		Att = PZ_2_ATT_Z(G, Z, P, wT); 	
		A = Att-min(Att);	
		Taug = PZ_2_TG_Z(G, Z, P, wT);
		S = S + X(m,1)*abs(H).^2;
	end 
	figure(1)
	subplot('position', [0.09 0.4 0.88 0.5]);	 
	PLOT_ATT_S_Z(Att, S, wT, 80, 400)
	hold on
	
	plot(wT, Taug,'linewidth',lw); 
	hold on
	
	text(0.8, 90,'Group Delay','FontName',fn,'FontSize',fs);
	text(0.5, 150,'Noise spectral density','FontName',fn,'FontSize',fs);
	%text(0.94,18.3,'\uparrow','fontsize',20)
	text(1.2,45,'\downarrow','fontsize',25)
	text(1.5,145,'\rightarrow','fontsize',25)
	zoom on
	
	figure(2)
	plot(wT, S,'linewidth',lw); 
	%	axis([0 pi 0 400])
	ylabel('{|\itG}({\ite^j^\omega^T})|','FontName', fn,'FontSize',fs);	
	
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xtick(ax,lab);
	grid on;
	sigma = sum(S)/length(S)
	
	
		
